/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.lib.gui.slot.SlotFalseCopy;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerBase
extends Container {
    protected abstract int getPlayerInventoryVerticalOffset();

    protected int getPlayerInventoryHorizontalOffset() {
        return 8;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int n;
        int n2 = this.getPlayerInventoryVerticalOffset();
        int n3 = this.getPlayerInventoryHorizontalOffset();
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 9; ++i) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i + n * 9 + 9, n3 + i * 18, n2 + n * 18));
            }
        }
        for (n = 0; n < 9; ++n) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, n, n3 + n * 18, n2 + 58));
        }
    }

    protected abstract int getSizeInventory();

    protected boolean supportsShiftClick(EntityPlayer entityPlayer, int n) {
        return this.supportsShiftClick(n);
    }

    protected boolean supportsShiftClick(int n) {
        return true;
    }

    protected boolean performMerge(EntityPlayer entityPlayer, int n, ItemStack itemStack) {
        return this.performMerge(n, itemStack);
    }

    protected boolean performMerge(int n, ItemStack itemStack) {
        int n2 = this.getSizeInventory();
        int n3 = this.inventorySlots.size();
        if (n < n2) {
            return this.mergeItemStack(itemStack, n2, n3, true);
        }
        return this.mergeItemStack(itemStack, 0, n2, false);
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int n) {
        if (!this.supportsShiftClick(entityPlayer, n)) {
            return null;
        }
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(n);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack2 = slot.getStack();
            itemStack = itemStack2.copy();
            if (!this.performMerge(entityPlayer, n, itemStack2)) {
                return null;
            }
            slot.onSlotChange(itemStack2, itemStack);
            if (itemStack2.stackSize <= 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.putStack(itemStack2);
            }
            if (itemStack2.stackSize == itemStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(entityPlayer, itemStack2);
        }
        return itemStack;
    }

    protected void sendSlots(int n, int n2) {
        n2 = MathHelper.clamp(n2, 0, this.inventorySlots.size());
        for (n = MathHelper.clamp(n, 0, this.inventorySlots.size()); n < n2; ++n) {
            ItemStack itemStack = ((Slot)this.inventorySlots.get(n)).getStack();
            ItemStack itemStack2 = itemStack == null ? null : itemStack.copy();
            this.inventoryItemStacks.set(n, itemStack2);
            for (int i = 0; i < this.crafters.size(); ++i) {
                ((ICrafting)this.crafters.get(i)).sendSlotContents((Container)this, n, itemStack2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void putStacksInSlots(ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            this.putStackInSlot(i, itemStackArray[i]);
        }
    }

    public ItemStack slotClick(int n, int n2, int n3, EntityPlayer entityPlayer) {
        Slot slot;
        Slot slot2 = slot = n < 0 ? null : (Slot)this.inventorySlots.get(n);
        if (slot instanceof SlotFalseCopy) {
            if (n2 == 2) {
                slot.putStack(null);
            } else {
                slot.putStack(entityPlayer.inventory.getItemStack() == null ? null : entityPlayer.inventory.getItemStack().copy());
            }
            return entityPlayer.inventory.getItemStack();
        }
        return super.slotClick(n, n2, n3, entityPlayer);
    }

    protected boolean mergeItemStack(ItemStack itemStack, int n, int n2, boolean bl) {
        return InventoryHelper.mergeItemStack(this.inventorySlots, itemStack, n, n2, bl);
    }
}

